/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.core.CoreStrings;
import com.aptana.ide.ui.io.Utils;
import com.aptana.ide.ui.io.navigator.actions.EditorUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenFileAction
extends BaseSelectionListenerAction {
    private List<IFileStore> fFileStores = new ArrayList<IFileStore>();

    public OpenFileAction() {
        super(CoreStrings.OPEN);
    }

    public void run() {
        for (IFileStore fileStore : this.fFileStores) {
            EditorUtils.openFileInEditor(fileStore, null);
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.fFileStores.clear();
        if (selection != null && !selection.isEmpty()) {
            Object[] elements;
            Object[] objectArray = elements = selection.toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore fileStore;
                Object element = objectArray[n2];
                if (element instanceof IAdaptable && (fileStore = Utils.getFileStore((IAdaptable)element)) != null) {
                    this.fFileStores.add(fileStore);
                }
                ++n2;
            }
        }
        return super.updateSelection(selection) && this.fFileStores.size() > 0;
    }
}

